/*
 * Decompiled with CFR 0.152.
 */
package fti.ti.sda;

import fti.ti.PraktikumHelper;
import java.util.Arrays;
import java.util.Random;

public class UtilSDA
extends PraktikumHelper {
    private static final char[] KONSONAN = new char[]{'b', 'c', 'd', 'l', 'm', 'n', 'r', 's', 't', 'v', 'w'};
    private static final char[] VOKAL = new char[]{'a', 'e', 'i', 'o', 'u', 'y'};
    private static Random random = new Random();
    private static final int PANJANG_MINIMAL = 4;
    private static final int PANJANG_MAKSIMAL = 8;

    public static String buatNama() {
        Arrays.sort(KONSONAN);
        Arrays.sort(VOKAL);
        int panjangNama = UtilSDA.tentukanPanjangNama();
        String nama = "";
        boolean ambilKonsonan = random.nextBoolean();
        while (nama.length() < panjangNama) {
            char temp = ambilKonsonan ? KONSONAN[random.nextInt(KONSONAN.length)] : VOKAL[random.nextInt(VOKAL.length)];
            nama = String.valueOf(nama) + temp;
            ambilKonsonan = random.nextBoolean();
            switch (temp) {
                case 'f': 
                case 'h': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 'v': 
                case 'w': 
                case 'y': 
                case 'z': {
                    ambilKonsonan = false;
                    break;
                }
                case 'e': {
                    ambilKonsonan = true;
                    break;
                }
                case 'c': 
                case 'g': {
                    if (!ambilKonsonan || panjangNama - nama.length() < 2) break;
                    nama = String.valueOf(nama) + 'h';
                    ambilKonsonan = false;
                    break;
                }
                case 'b': 
                case 't': {
                    if (!ambilKonsonan || panjangNama - nama.length() < 2) break;
                    nama = String.valueOf(nama) + (random.nextBoolean() ? (char)'h' : 's');
                    ambilKonsonan = false;
                }
            }
            if (nama.length() >= 2) {
                if (UtilSDA.isVokal(nama.charAt(nama.length() - 1)) == UtilSDA.isVokal(nama.charAt(nama.length() - 2))) {
                    ambilKonsonan = UtilSDA.isVokal(nama.charAt(nama.length() - 1));
                }
                if (nama.charAt(0) == nama.charAt(1)) {
                    nama = nama.substring(1);
                }
            }
            if (panjangNama - nama.length() != 1 || UtilSDA.isVokal(nama.charAt(nama.length() - 1))) continue;
            ambilKonsonan = false;
        }
        return String.valueOf(nama.substring(0, 1).toUpperCase()) + nama.substring(1);
    }

    public static int tentukanPanjangNama() {
        int panjang = -1;
        while ((panjang = 4 + random.nextInt(5)) <= 0 || panjang > 8) {
        }
        return panjang;
    }

    public static boolean isVokal(char ch) {
        Arrays.sort(VOKAL);
        return Arrays.binarySearch(VOKAL, ch) > -1;
    }
}

