/**
 * Linked List SDA
 * 
 * Kelas ini digunakan untuk mempermudah kegiatan praktikum mata kuliah 
 * Struktur Data dan Algoritma di Program Studi Teknik Informatika, 
 * Fakultas Teknologi Informasi, Universitas YARSI.
 * 
 * Implementasi Double Linked List ini selalu menyimpan alamat ke node pertama
 * (i.e., first) dan terakhir (i.e., last). Implementasi node yang digunakan 
 * dalam kelas ini adalah Node SDA; silahkan baca dokumentasi NodeSDA untuk 
 * informasi lebih lengkap. 
 * 
 * Untuk mempermudah kegiatan praktikum, kelas ini memiliki method bernama
 * updateReference() yang akan secara otomatis memperbaiki posisi node pertama
 * dan terakhir. Method ini perlu dipanggil setiap ada operasi yang mengubah 
 * struktur LinkedList (i.e., penambahan atau pengurangan node).
 * 
 * Catatan tentang implementasi first dan last: 
 * Ketika diinisalisasi (i.e., dibentuk pertama kali), first dan last menunjuk 
 * ke sebuah NodeSDA yang berisi null; node ini tidak akan dihitung sebagai 
 * elemen LinkedList dan juga tidak akan tercetak. Cara seperti ini 
 * memungkinkan implementasi generik untuk menambahkan sebuah node ke dalam 
 * Linked List.  
 */

package fti.ti.sda;

//PraktikumHelper diperlukan untuk standarisasi seluruh kelas Praktikum Helper.
import fti.ti.PraktikumHelper;
// Random digunakan untuk menentukan node awal untuk mencetak isi Linked List 
// SDA, dari node pertama atau terakhir.
import java.util.Random;

/**
 * @author  Andreas Febrian
 * @version 1.01
 * 
 * version 1.00: 
 * - Mengimplementasikan sebuah Double Linked List yang memiliki alamat ke node 
 * pertama dan terakhir. 
 * - Mengimplementasikan cara mengakses node pertama dan terakhir melalui 
 * getter method.
 * - Mengimplementasikan otomatisasi untuk memperbaharui alamat node pertama 
 * dan terakhir. 
 * version 1.01: 
 * - Menambahkan dan memperbaiki dokumentasi program. 
 * - Memindahkan package dari com.sda menjadi fti.ti.
 * - Mengimplementasikan kelas ini sebagai turunan dari PraktikumHelper.
 * - Mengimplementasikan tipe generic, mengikuti perubahan pada kelas NodeSDA.
 * - Refactoring: variabel head hanya digunakan satu kali, yaitu pada saat 
 * memberikan alamat awal ke first; kode tersebut disederhanakan.
 * - Refactoring: menyederhanakan 
 */
public class LinkedListSDA<E> extends PraktikumHelper{
	
	/**
	 * Alamat elemen pertama dari LinkedList ini. Pada saat dibuat pertama 
	 * kali, first akan menunjuk ke sebuah NodeSDA yang berisi null. 
	 * Baca keterangan tentang implementasi first dan last untuk informasi 
	 * lebih lengkap.    
	 */
	private NodeSDA<E> first;
	/**
	 * Alamat elemen terakhir dari LinkedList ini. Pada saat dibuat pertama 
	 * kali, last akan menunjuk ke sebuah NodeSDA yang berisi null, yang juga 
	 * ditunjuk oleh first. Baca keterangan tentang implementasi first dan last 
	 * untuk informasi lebih lengkap.   
	 */
	private NodeSDA<E> last;
	/**
	 * Jumlah element, selain dari head, yang disimpan dalam LinkedList ini. 
	 */
	private int size;

	/**
	 * Membuat sebuah instance dari Linked List SDA baru; tidak memiliki elemen 
	 * apapun, kecuali yang berhubungan dengan implementasi first dan last.
	 */
	public LinkedListSDA() {
		// first menunjuk ke node awal dari Linked List ini 
		// (i.e., node berisi null)
		first = new NodeSDA<E>(null, null, null); 
		// last menunjuk ke node awal dari Linked List ini (i.e., first)
		last = first;
		// karena baru dibuat, maka panjang LinkedList adalah nol
		size = 0;
	}
	
	/**
	 * Membaca panjang LinkedList. 
	 * @return Jumlah elemen dalam LinkedList
	 */
	public int size() {
		return size; 
	}
	
	/**
	 * Mendapatkan elemen pertama dari LinkedList ini.
	 * @return NodeSDA yang menjadi elemen pertama dari LinkedList ini.
	 */
	public NodeSDA<E> getFirst() {
		// jika belum ada data yang disimpan dalam LinkedList
		if(first.next == null || size == 0)
			return first; // kembalikan head
		// jika sudah ada data yang disimpan, kembalikan data pertama
		return first.next;
	}
	
	/**
	 * Mendapatkan elemen terakhir dari LinkedList ini.  
	 * @return NodeSDA yang menjadi elemen terakhir dari LinkedList ini.
	 */
	public NodeSDA<E> getLast() {
		return last;
	}
	
	/**
	 * Menyesuaikan posisi last dan size berdasarkan data yang terdapat dalam 
	 * Linked List ini. 
	 * 
	 * Method ini dibuat untuk mempermudah kegiatan praktikum dan harus 
	 * dipanggil setiap kali ada perubahan struktur Linked List, seperti jika 
	 * ada data yang ditambah atau dihapus dari Linked List.  
	 */
	public void updateReferences() {
		last = first; // kembalikan last ke posisi awal 
		size = 0; // kembalikan ukuran
		// lakukan hal berikut sampai elemen terakhir
		while(last.next != null) { 
			last = last.next; // pindahkan last ke posisi berikutnya
			size++; // catat jumlah elemen dalam LinkedList
		}
	}
	
	/**
	 * Mencetak seluruh elemen dalam LinkedList ini dalam format yang serupa 
	 * dengan struktur LinkedList pada Java(TM).  
	 * 
	 * Untuk memastikan praktikum dikerjakan dengan tepat, setiap kali 
	 * dipanggil, method ini akan memilih untuk membaca data dari elemen 
	 * pertama atau terakhir. Ada kalanya ketika menambahkan atau menghapus 
	 * sebuah node, yang diubah hanya salah satu dari prev atau next dari salah 
	 * satu node tersebut. 
	 */
	public void print() {
		String output = ""; // tempat untuk simpan keluaran
		NodeSDA<E> current; // tempat untuk menunjuk node yang akan diproses
		// secara acak, pilih untuk membaca dari depan atau belakang LinkedList
		if((new Random()).nextBoolean()) { // membaca dari depan
			current = first.next; // baca alamat node pertama
			// lakukan hal berikut selama belum mencapai node terakhir
			while(current != null) {
				// baca data dalam node dan simpan untuk dicetak
				output += ", " + current.getData();
				current = current.next; // pindah ke data berikutnya
				
			}
		}else { // membaca dari belakang
			current = last; // baca alamat node terakhir
			// lakukan hal berikut selama belum mencapai node pertama
			while(current != first) {
				// baca data dalam node dan simpan untuk dicetak
				output = ", " + current.getData() + output; 
				current = current.prev; // pindah ke data sebelumnya
			}
		}
		// cetak seluruh elemen dalam LinkedList sesuai format
		System.out.println("[" + 
				(!output.isEmpty() ? output.substring(2) : "") + "]");
	}
}

