/**
 * Praktikum Helper Exception 
 * 
 * Kelas ini sengaja dibuat sebagai Exception untuk seluruh kelas Praktikum 
 * Helper dalam kuliah Struktur Data dan Algoritma di Program Studi
 * Teknik Informatika, Fakultas Teknologi Informasi, Universitas YARSI. 
 * 
 * Adanya kelas Exception tersendiri untuk Praktikum Helper diharapkan dapat 
 * mempermudah mahasiswa dalam mengidentifikasi permasalah yang muncul dalam 
 * kode program mereka, khususnya yang menggunakan Praktikum Helper. 
 */

package fti.ti;

/**
 * @author  Andreas Febrian
 * @version 1.02
 * 
 * version 1.00: 
 * - Versi awal dengan konstruktur standar. 
 * version 1.01: 
 * - Menambahkan konstruktur yang memproses non-standar. 
 * version 1.02: 
 * - Penambahan dan perbaikan dokumentasi program.
 * - Mengubah dokumentasi ke dalam bahasa Indonesia untuk mempermudah mahasiswa 
 * dalam mempelajari kode program ini. 
 * - Perpindahan package dari com.sda menjadi fti.ti.
 */
public class PraktikumHelperException extends Exception {

	/**
	 * Property ini dibuat secara otomatis oleh Eclipse. Variabel ini dibiarkan 
	 * dan digunakan tanpa ada perubahan yang dilakukan terhadap nilainya.   
	 */
	private static final long serialVersionUID = -990285912613714832L;

	/**
	 * Constructor dengan pesan standar terkait Exception yang berhubungan 
	 * dengan kelas Praktikum Helper. 
	 */
	public PraktikumHelperException() {
		super("Terjadi sebuah Exception yang berhubungan dengan kelas "
				+ "Praktikum Helper yang Anda gunakan. Silahkan lihat "
				+ "dokumentasi API atau lainnya untuk informasi lebih "
				+ "lebih lengkap");
	}

	/**
	 * Constructor yang dapat memproses pesan non-standar. 
	 * @param message Pesan yang akan ditampikan ke pengguna
	 */
	public PraktikumHelperException(String message) {
		super(message);
	}
}

