/**
 * Node SDA
 * 
 * Kelas ini digunakan untuk mempermudah kegiatan praktikum mata kuliah 
 * Struktur Data dan Algoritma di Program Studi Teknik Informatika, 
 * Fakultas Teknologi Informasi, Universitas YARSI.
 * 
 * Kelas ini berperan sebagai sebuah node yang memiliki dua tangan, yaitu prev 
 * dan next. Prev menunjuk alamat dari node sebelum node ini, sedangkan next 
 * menunjuk alamat dari node setelah node ini. Setelah dideklarasikan, data 
 * yang tersimpan tidak dapat diubah.      
 */

package fti.ti.sda;

//PraktikumHelper diperlukan untuk standarisasi seluruh kelas Praktikum Helper.
import fti.ti.PraktikumHelper;

/**
 * @author  Andreas Febrian
 * @version 1.01
 * 
 * version 1.00: 
 * - Mengimplementasikan sebuah node yang menunjuk kedua buah alamat node lain, 
 * yang diberi label prev dan next. 
 * version 1.01: 
 * - Menambahkan dan memperbaiki dokumentasi program. 
 * - Memindahkan package dari com.sda menjadi fti.ti.
 * - Mengimplementasikan kelas ini sebagai turunan dari PraktikumHelper.
 * - Mengimplementasikan generic sehingga node bisa menyimpan berbagai jenis 
 * tipe data reference.  
 * - Membuat data yang sudah disimpan immutable, sehingga tidak memungkinkan 
 * untuk diganti.
 */
public class NodeSDA<E> extends PraktikumHelper{
	
	/**
	 * Data yang disimpan di dalam node. Setelah dibuat pertama kali, data ini 
	 * tidak dapat diubah-ubah.  
	 */
	private E data; 
	/**
	 * Menunjuk ke node lain yang secara konseptual terletak sebelum node ini.  
	 */
	public NodeSDA<E> prev;
	/**
	 * Menunjuk ke node lain yang secara konseptual terletak setelah node ini. 
	 */
	public NodeSDA<E> next; 

	/**
	 * Membuat sebuah node baru yang menyimpan data yang diberikan. Setelah 
	 * dibentuk, prev dan next tidak menunjuk pada node apapun (i.e., null).
	 * @param data Tipe reference yang ingin disimpan dalam node ini
	 */
	public NodeSDA(E data) {
		this.data = data;
	}
	
	/**
	 * Membuat sebuah node baru yang menyimpan data yang diberikan. Setelah 
	 * dibentuk, prev dan next tidak menunjuk pada NodeSDA yang diberikan.
	 * @param data Tipe reference yang ingin disimpan dalam node ini
	 * @param prev Alamat NodeSDA sebelum node ini
	 * @param next Alamat NodeSDA setelah node ini
	 */
	public NodeSDA(E data, NodeSDA<E> prev, NodeSDA<E> next) {
		this.data = data; 
		this.prev = prev;
		this.next = next;
	}
	
	/**
	 * Membaca data yang tersimpan dalam node ini. 
	 * @return data yang tersimpan dalam node ini. 
	 */
	public E getData() {
		return data;
	}
}
