/*
 * Decompiled with CFR 0.152.
 */
package com.sda;

import com.sda.PraktikumHelper;
import java.io.IOException;
import java.util.Scanner;

public class Praktikum4Helper
implements PraktikumHelper<Object> {
    private char[][] maze;
    private int[] startPos = new int[2];
    private int[] endPos = new int[2];
    private int[] playerPos;
    private boolean needToClearScreen;
    private boolean needToSleep;
    private int sleepTime;
    public static final int EASY_MAZE = 0;
    public static final int MEDIUM_MAZE = 1;
    public static final int HARD_MAZE = 2;
    public static final int FAST_ANIMATION = 450;
    public static final int NORMAL_ANIMATION = 1000;

    public Praktikum4Helper() {
        this(0);
    }

    public Praktikum4Helper(int n) {
        this.initializedMaze(n);
        this.playerPos = new int[2];
        this.playerPos[0] = this.startPos[0];
        this.playerPos[1] = this.startPos[1];
        this.needToClearScreen = true;
        this.needToSleep = true;
        this.sleepTime = 1000;
        this.printMaze();
    }

    public void setAnimationSpeed(int n) {
        this.sleepTime = n;
    }

    public void interactivePlay() {
        Scanner scanner = new Scanner(System.in);
        String string = null;
        String string2 = "";
        while (true) {
            this.clearScreen();
            this.needToClearScreen = false;
            this.needToSleep = false;
            if (string != null && !string.isEmpty()) {
                string2 = this.moveTo(string.charAt(0));
            }
            this.needToSleep = false;
            this.printMaze();
            System.out.println(string2);
            System.out.println();
            if (this.isAtEndPosition()) break;
            System.out.println("Tentukan langkah berikutnya:\nw - utara/atas     a - barat/kiri\ns - selatan/bawah  d - timur/kanan");
            System.out.print("Langkah Anda: ");
            string = scanner.nextLine();
        }
        System.out.println("Anda menang!!!");
        scanner.close();
    }

    public void demo() {
        if (this.runAI('x')) {
            System.out.println("Reach finish line!");
        } else {
            System.out.println("Unable to reach finish line!");
        }
    }

    private boolean runAI(char c) {
        if (!this.isAtEndPosition() && c != 'w' && this.canGoEast()) {
            this.goEast();
            if (!this.runAI('e')) {
                this.goWest();
            }
        }
        if (!this.isAtEndPosition() && c != 'n' && this.canGoSouth()) {
            this.goSouth();
            if (!this.runAI('s')) {
                this.goNorth();
            }
        }
        if (!this.isAtEndPosition() && c != 'e' && this.canGoWest()) {
            this.goWest();
            if (!this.runAI('w')) {
                this.goEast();
            }
        }
        if (!this.isAtEndPosition() && c != 's' && this.canGoNorth()) {
            this.goNorth();
            if (!this.runAI('n')) {
                this.goSouth();
            }
        }
        return this.isAtEndPosition();
    }

    public boolean canGoEast() {
        return this.maze[this.playerPos[0]][this.playerPos[1] + 1] != '#';
    }

    public boolean goEast() {
        boolean bl = this.canGoEast();
        this.playerPos[1] = this.playerPos[1] + (bl ? 1 : 0);
        this.printMaze();
        return bl;
    }

    public boolean canGoSouth() {
        return this.maze[this.playerPos[0] + 1][this.playerPos[1]] != '#';
    }

    public boolean goSouth() {
        boolean bl = this.canGoSouth();
        this.playerPos[0] = this.playerPos[0] + (bl ? 1 : 0);
        this.printMaze();
        return bl;
    }

    public boolean canGoWest() {
        return this.maze[this.playerPos[0]][this.playerPos[1] - 1] != '#';
    }

    public boolean goWest() {
        boolean bl = this.canGoWest();
        this.playerPos[1] = this.playerPos[1] - (bl ? 1 : 0);
        this.printMaze();
        return bl;
    }

    public boolean canGoNorth() {
        return this.maze[this.playerPos[0] - 1][this.playerPos[1]] != '#';
    }

    public boolean goNorth() {
        boolean bl = this.canGoNorth();
        this.playerPos[0] = this.playerPos[0] - (bl ? 1 : 0);
        this.printMaze();
        return bl;
    }

    private String moveTo(char c) {
        this.needToSleep = false;
        String string = "";
        switch (c) {
            case 'w': {
                string = this.goNorth() ? "" : "Tidak bisa bergerak ke utara.";
                break;
            }
            case 'a': {
                string = this.goWest() ? "" : "Tidak bisa bergerak ke barat.";
                break;
            }
            case 's': {
                string = this.goSouth() ? "" : "Tidak bisa bergerak ke selatan.";
                break;
            }
            case 'd': {
                string = this.goEast() ? "" : "Tidak bisa bergerak ke timur.";
                break;
            }
            default: {
                string = "Perintah " + c + "tidak dikenal.";
            }
        }
        return string;
    }

    public boolean isAtEndPosition() {
        return this.playerPos[0] == this.endPos[0] && this.playerPos[1] == this.endPos[1];
    }

    private void clearScreen() {
        try {
            new ProcessBuilder("cmd", "/c", "cls").inheritIO().start().waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printMaze() {
        if (this.needToClearScreen) {
            this.clearScreen();
        }
        int n = 32;
        for (int i = 0; i < this.maze.length; ++i) {
            for (int j = 0; j < this.maze[i].length; ++j) {
                n = this.startPos[0] == i && this.startPos[1] == j ? 83 : this.maze[i][j];
                n = this.endPos[0] == i && this.endPos[1] == j ? 70 : n;
                n = this.playerPos[0] == i && this.playerPos[1] == j ? 88 : n;
                System.out.print((char)n);
            }
            if (i == this.maze.length - 3) {
                System.out.print(" S: Pintu masuk");
            } else if (i == this.maze.length - 2) {
                System.out.print(" F: Pintu keluar");
            } else if (i == this.maze.length - 1) {
                System.out.print(" X: Pemain");
            }
            System.out.println();
        }
        System.out.println();
        try {
            if (this.needToSleep) {
                Thread.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.needToClearScreen = true;
        this.needToSleep = true;
    }

    private void initializedMaze(int n) {
        String[][] stringArrayArray = new String[][]{{"###################", "#               ###", "######### #########", "######### #### ####", "######### #### ####", "##                #", "#### ###### ##### #", "#### ###### ##### #", "#### ###### ##### #", "##   ###### #######", "####   ##       ###", "###################"}, {"###################", "#                ##", "###### #### #### ##", "##       ## ## # ##", "########### ## # ##", "#  #        ##    #", "## # ### ## ##### #", "## # # #   ## ### #", "## # # ###  #     #", "#    # #### ## ## #", "# ##   ##   #  ## #", "###################"}, {"###################", "#                 #", "# ### # # # # ### #", "# ###   #     ### #", "# ### # ### # ### #", "#                 #", "# ### # # # # ### #", "#   # # # #   ### #", "# ###   # # # #   #", "# ### # ### # ### #", "#                 #", "###################"}};
        int[][] nArrayArray = new int[][]{{1, 1}, {3, 14}, {10, 9}};
        int[][] nArrayArray2 = new int[][]{{10, 15}, {5, 2}, {8, 9}};
        n = n > 2 || n < 0 ? 0 : n;
        this.maze = new char[stringArrayArray[n].length][stringArrayArray[n][0].length()];
        for (int i = 0; i < stringArrayArray[n].length; ++i) {
            this.maze[i] = stringArrayArray[n][i].toCharArray();
        }
        this.startPos[0] = nArrayArray[n][0];
        this.startPos[1] = nArrayArray[n][1];
        this.endPos[0] = nArrayArray2[n][0];
        this.endPos[1] = nArrayArray2[n][1];
    }
}

